/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.graphics.textmc;

import icyllis.modernui.graphics.textmc.MutableString;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.ICharacterConsumer;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.text.Style;

public class ReorderTextHandler {
    private final MutableString mBuffer = new MutableString();
    @Nullable
    private Style mLast;
    private IConsumer mConsumer;
    private final ICharacterConsumer mSink = new ICharacterConsumer(){

        public boolean accept(int index, @Nonnull Style style, int codePoint) {
            if (style != ReorderTextHandler.this.mLast) {
                if (!ReorderTextHandler.this.mBuffer.isEmpty() && ReorderTextHandler.this.mLast != null && ReorderTextHandler.this.mConsumer.handle(ReorderTextHandler.this.mBuffer, ReorderTextHandler.this.mLast)) {
                    ReorderTextHandler.this.mBuffer.clear();
                    ReorderTextHandler.this.mLast = style;
                    return false;
                }
                ReorderTextHandler.this.mBuffer.clear();
                ReorderTextHandler.this.mLast = style;
            }
            ReorderTextHandler.this.mBuffer.addCodePoint(codePoint);
            return true;
        }
    };

    public boolean handle(@Nonnull IReorderingProcessor sequence, IConsumer consumer) {
        this.mConsumer = consumer;
        if (sequence.accept(this.mSink)) {
            return this.finish();
        }
        return false;
    }

    private boolean finish() {
        if (!this.mBuffer.isEmpty() && this.mLast != null && this.mConsumer.handle(this.mBuffer, this.mLast)) {
            this.mBuffer.clear();
            this.mLast = null;
            return false;
        }
        this.mBuffer.clear();
        this.mLast = null;
        return true;
    }

    @FunctionalInterface
    public static interface IConsumer {
        public boolean handle(CharSequence var1, Style var2);
    }
}

